


/**
 ******************************************************************************
 *
 * @file        BSP_ARGBTable.c
 * @brief       ARGB string table
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.00
 * @date        2022/03/02
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z.h"
#include "BSP_ARGB.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/** 
 * @name  ARGB mapping table
 */
///@{
uint8_t const ARGB_Table[ARGB_COLUMN][ARGB_ROW] = {
                                                    { 0, 1, 2, 3, 4, 5},
                                                    {11,10, 9, 8, 7, 6},
                                                    {12,13,14,15,16,17},
                                                    {23,22,21,20,19,18},
                                                    {24,25,26,27,28,29},
                                                    {35,34,33,32,31,30},
                                                    {36,37,38,39,40,41},
                                                    {47,46,45,44,43,42}
                                                  };
///@}
                                                      
/** 
 * @name  ARGB String Table 
 */                                                      
///@{                                                      
                                                      
uint8_t const ARGB_StringTable[ ASCII_TOTAL_TABLE * ( ASCII_ROW * ASCII_COLUM) ] = 
{
    //====================================================
    //SPACE
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    //====================================================
    //0
    0, 0, 1, 1, 1, 0,
    0, 1, 1, 0, 1, 1,
    0, 1, 1, 0, 1, 1,
    0, 1, 1, 0, 1, 1,
    0, 1, 1, 0, 1, 1,
    0, 1, 1, 0, 1, 1,
    0, 0, 1, 1, 1, 0,
    //====================================================
    //1
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //2
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    0, 0, 0, 0, 1, 1,
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 0,
    1, 1, 1, 1, 1, 1,
    //====================================================
    //3
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    0, 0, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //4
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 1, 1, 0,
    0, 1, 0, 1, 1, 0,
    1, 0, 0, 1, 1, 0,
    1, 0, 0, 1, 1, 0,
    1, 1, 1, 1, 1, 1,
    0, 0, 0, 1, 1, 0,
    //====================================================
    //5
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //6
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //7
    0, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 1, 1,
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //8
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //9
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //A
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //B
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    //====================================================
    //C
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //D
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    //====================================================
    //E
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1,
    //====================================================
    //F
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    //====================================================
    //G
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //H
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //I
    1, 1, 1, 1, 1, 1,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    1, 1, 1, 1, 1, 1,
    //====================================================
    //J
    1, 1, 1, 1, 1, 1,
    0, 0, 0, 1, 1, 0,
    0, 0, 0, 1, 1, 0,
    0, 0, 0, 1, 1, 0,
    1, 0, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //K
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 1, 1, 0,
    1, 1, 1, 1, 0, 0,
    1, 1, 1, 1, 0, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 1,
    //====================================================
    //L
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1,
    //====================================================
    //M
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1,
    1, 0, 1, 1, 0, 1,
    1, 0, 1, 1, 0, 1,
    1, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 1,
    //====================================================
    //N
    1, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 0, 1, 1,
    1, 0, 1, 1, 1, 1,
    1, 0, 0, 1, 1, 1,
    1, 0, 0, 0, 1, 1,
    1, 0, 0, 0, 1, 1,
    //====================================================
    //O
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //P
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    //====================================================
    //Q
    0, 1, 1, 1, 0, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 1, 1, 1,
    0, 1, 1, 1, 0, 1,
    //====================================================
    //R
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //S
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    0, 0, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //T
    1, 1, 1, 1, 1, 1,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //U
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //V
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 0, 0, 1, 0,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //W
    1, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 1,
    1, 0, 1, 1, 0, 1,
    1, 0, 1, 1, 0, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //X
    1, 0, 0, 0, 0, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 0, 0, 0, 0, 1,
    //====================================================
    //Y
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //Z
    1, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 1, 1,
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1,
    //====================================================
    //a
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    0, 1, 1, 0, 1, 1,
    //====================================================
    //b
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    //====================================================
    //c
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //d
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1,
    0, 0, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 1,
    //====================================================
    //e
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //f
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 1, 1, 1,
    0, 0, 1, 1, 0, 1,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //g
    0, 0, 1, 1, 1, 1,
    0, 0, 1, 0, 1, 0,
    0, 0, 1, 1, 1, 0,
    0, 0, 1, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    0, 1, 0, 0, 1, 0,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //h
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //i
    0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //j
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 0,
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 0,
    0, 0, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    0, 1, 1, 1, 0, 0,
    //====================================================
    //k
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 1, 1, 0,
    1, 1, 1, 1, 0, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //l
    0, 1, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //m
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 0, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 1, 0, 1,
    1, 1, 0, 1, 0, 1,
    1, 1, 0, 1, 0, 1,
    //====================================================
    //n
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //o
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //p
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 0, 0,
    //====================================================
    //q
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 1,
    0, 0, 0, 0, 1, 1,
    //====================================================
    //r
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 1, 1, 1, 1,
    1, 1, 1, 0, 0, 1,
    1, 1, 0, 0, 0, 0,
    1, 1, 0, 0, 0, 0,
    //====================================================
    //s
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    0, 1, 1, 0, 0, 0,
    0, 1, 1, 1, 1, 0,
    0, 0, 0, 1, 1, 0,
    0, 1, 1, 1, 1, 0,
    //====================================================
    //t
    0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 0, 0,
    0, 0, 1, 1, 1, 0,
    //====================================================
    //u
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 0, 1, 1, 0,
    1, 1, 1, 0, 1, 1,
    //====================================================
    //v
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    //====================================================
    //w
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 1,
    1, 0, 0, 0, 0, 1,
    1, 0, 1, 1, 0, 1,
    1, 1, 1, 1, 1, 1,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //x
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 0,
    1, 1, 0, 0, 1, 1,
    //====================================================
    //y
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, 1, 1,
    1, 1, 0, 0, 1, 1,
    0, 1, 1, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    1, 1, 1, 0, 0, 0,
    //====================================================
    //z
    0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0,
    0, 1, 1, 1, 1, 1,
    0, 0, 1, 0, 1, 1,
    0, 0, 0, 1, 1, 0,
    0, 0, 1, 1, 0, 0,
    0, 1, 1, 1, 1, 1,
};    
                                                      
///@}


/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/ 
 
 



















